// dfs.java
// demonstracja wyszukiwania "wgb"
// aby uruchomi program: C:>java DFSApp (wersja angielska)
// aby skompilowa wersj polsk: C:>javac dfs.java
// po kompilacji:         C:>java DFSApp
////////////////////////////////////////////////////////////////
class StackX
   {
   private final int SIZE = 20;
   private int[] st;
   private int top;
// ------------------------------------------------------------
   public StackX()           // konstruktor
      {
      st = new int[SIZE];    // utwrz tablic
      top = -1;
      }
// ------------------------------------------------------------
   public void push(int j)   // zapisz element na stosie
      { st[++top] = j; }
// ------------------------------------------------------------
   public int pop()          // pobierz element ze stosu
      { return st[top--]; }
// ------------------------------------------------------------
   public int peek()     // pobierz warto elementu na szczycie stosu
      { return st[top]; }
// ------------------------------------------------------------
   public boolean isEmpty()  // 'prawda', jeeli stos jest pusty
      { return (top == -1); }
// ------------------------------------------------------------
   }  // end class StackX
////////////////////////////////////////////////////////////////
class Vertex
   {
   public char label;        // etykieta (np. 'A')
   public boolean wasVisited;
// ------------------------------------------------------------
   public Vertex(char lab)   // konstruktor
      {
      label = lab;
      wasVisited = false;
      }
// ------------------------------------------------------------
   }  // end class Vertex
////////////////////////////////////////////////////////////////
class Graph
   {
   private final int MAX_VERTS = 20;
   private Vertex vertexList[]; // lista wierzchokw
   private int adjMat[][];      // matryca przylegania
   private int nVerts;          // bieca liczba wierzchokw
   private StackX theStack;
// ------------------------------------------------------------
   public Graph()               // konstruktor
      {
      vertexList = new Vertex[MAX_VERTS];
                                          // matryca przylegania
      adjMat = new int[MAX_VERTS][MAX_VERTS];
      nVerts = 0;
      for(int y=0; y<MAX_VERTS; y++)      // zerowanie matrycy
         for(int x=0; x<MAX_VERTS; x++)   //    przylegania
            adjMat[x][y] = 0;
      theStack = new StackX();
      }  // end constructor
// ------------------------------------------------------------
   public void addVertex(char lab)
      {
      vertexList[nVerts++] = new Vertex(lab);
      }
// ------------------------------------------------------------
   public void addEdge(int start, int end)
      {
      adjMat[start][end] = 1;
      adjMat[end][start] = 1;
      }
// ------------------------------------------------------------
   public void displayVertex(int v)
      {
      System.out.print(vertexList[v].label);
      }
// ------------------------------------------------------------
   public void dfs()  // wyszukiwanie "wgb"
      {                                 // rozpocznij od wierzchoka 0
      vertexList[0].wasVisited = true;  // oznacz wierzchoek
      displayVertex(0);                 // wywietl wierzchoek
      theStack.push(0);                 // zapisz na stos

      while( !theStack.isEmpty() )      // do oprnienia stosu,
         {
         // pobierz nie odwiedzony wierzchoek, przylegy do szczytowego elementu stosu
         int v = getAdjUnvisitedVertex( theStack.peek() );
         if(v == -1)                    // jeeli nie ma takiego wierzchoka,
            theStack.pop();
         else                           // jeeli istnieje,
            {
            vertexList[v].wasVisited = true;  // oznacz wierzchoek
            displayVertex(v);                 // wywietl wierzchoek
            theStack.push(v);                 // zapisz na stos
            }
         }  // end while

      // stos pusty, procedura zakoczona
      for(int j=0; j<nVerts; j++)          // zerowanie znacznikw
         vertexList[j].wasVisited = false;
      }  // end dfs
// ------------------------------------------------------------
   // zwraca nie odwiedzony wierzchoek przylegy do v
   public int getAdjUnvisitedVertex(int v)
      {
      for(int j=0; j<nVerts; j++)
         if(adjMat[v][j]==1 && vertexList[j].wasVisited==false)
            return j;
      return -1;
      }  // end getAdjUnvisitedVertex()
// ------------------------------------------------------------
   }  // end class Graph
////////////////////////////////////////////////////////////////
class DFSApp
   {
   public static void main(String[] args)
      {
      Graph theGraph = new Graph();
      theGraph.addVertex('A');    // 0  (pocztek wyszukiwania DFS)
      theGraph.addVertex('B');    // 1
      theGraph.addVertex('C');    // 2
      theGraph.addVertex('D');    // 3
      theGraph.addVertex('E');    // 4

      theGraph.addEdge(0, 1);     // AB
      theGraph.addEdge(1, 2);     // BC
      theGraph.addEdge(0, 3);     // AD
      theGraph.addEdge(3, 4);     // DE

      System.out.print("Odwiedzone wierzchoki: ");
      theGraph.dfs();             // wyszukiwanie "wgb"
      System.out.println();
      }  // end main()
   }  // end class DFSApp
////////////////////////////////////////////////////////////////

